import { a6d28777ab56c8416 } from "./internal/aa89649a981b0bfc2/a6d28777ab56c8416";
import { StarIO10ArgumentError, StarIO10CommunicationError, StarIO10ErrorCode, StarIO10ErrorMessage, StarIO10IllegalDeviceStateError, StarIO10UnknownError, } from "./star-io10-error/";
import { StarIO10ErrorFactory } from "./star-io10-error/StarIO10ErrorFactory";
import { StarIO10Logger } from "./StarIO10Logger";
import { aaca0adc50034daa9 } from "./internal/a7917fe845517cd99/aaca0adc50034daa9";
import { a341439e4e686906a } from "./internal/acf0e9bfb1cb9236c/a341439e4e686906a";
import { a01d5a0be5bc5ddb1 } from "./internal/a01d5a0be5bc5ddb1";
import { GetInformationOptions, GetStatusOptions, OpenOptions, PrintOptions, } from "./options";
import { a8fd55883fc29bb24 } from "./internal/a235456a4198990c7/a8fd55883fc29bb24";
import { a529e5d8b404994c7 } from "./internal/a235456a4198990c7/a529e5d8b404994c7";
import { a65e77a918bb6bf2d } from "./internal/a235456a4198990c7/a65e77a918bb6bf2d";
import { a21766f2e932e2b0f } from "./internal/a235456a4198990c7/a21766f2e932e2b0f";
import { a958398b4ee45784f } from "./internal/a958398b4ee45784f";
/* eslint-disable @typescript-eslint/no-unsafe-member-access, @typescript-eslint/no-unsafe-assignment, @typescript-eslint/no-unsafe-argument */
export class StarPrinter {
    //Web Workerを使用して、UIの処理をブロックしないようにする。
    _starPrinterWorker;
    get starPrinterWorker() {
        if (!this._starPrinterWorker) {
            this._starPrinterWorker = new Worker(new URL("./internal/a1db3cae20effba68.js", import.meta.url));
            this.connectionSettings = this._connectionSettings.connectionSettings;
        }
        return this._starPrinterWorker;
    }
    async checkStarPrinterWorker(timeout) {
        const worker = this._starPrinterWorker;
        if (!worker) {
            const throwE = new StarIO10IllegalDeviceStateError(StarIO10ErrorMessage.WebWorkerUnavailable.message, StarIO10ErrorCode.WebWorkerUnavailable);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }
        const timer = setTimeout(() => {
            this._starPrinterWorker = undefined;
            const throwE = new StarIO10IllegalDeviceStateError(StarIO10ErrorMessage.WebWorkerUnavailable.message, StarIO10ErrorCode.WebWorkerUnavailable);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }, timeout);
        const result = await new Promise((resolve) => {
            const workerTaskID = this.createWorkerTaskID();
            worker.postMessage({
                id: workerTaskID,
                type: a958398b4ee45784f.ping,
            });
            worker.onmessage = (event) => {
                if (event.data.id == workerTaskID) {
                    if (event.data.type === a958398b4ee45784f.pong) {
                        clearTimeout(timer);
                        resolve(true);
                    }
                }
            };
        });
        return Promise.resolve(result);
    }
    _starXpandCommandParserWorker;
    get starXpandCommandParserWorker() {
        if (!this._starXpandCommandParserWorker) {
            this._starXpandCommandParserWorker = new Worker(new URL("./internal/aedb43fd9d6e8cf4b.js", import.meta.url));
        }
        return this._starXpandCommandParserWorker;
    }
    async checkStarXpandCommandParserWorker(timeout) {
        const worker = this._starXpandCommandParserWorker;
        if (!worker) {
            const throwE = new StarIO10IllegalDeviceStateError(StarIO10ErrorMessage.WebWorkerUnavailable.message, StarIO10ErrorCode.WebWorkerUnavailable);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }
        const timer = setTimeout(() => {
            this._starXpandCommandParserWorker = undefined;
            const throwE = new StarIO10IllegalDeviceStateError(StarIO10ErrorMessage.WebWorkerUnavailable.message, StarIO10ErrorCode.WebWorkerUnavailable);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }, timeout);
        const result = await new Promise((resolve) => {
            const workerTaskID = this.createWorkerTaskID();
            worker.postMessage({
                id: workerTaskID,
                type: a958398b4ee45784f.ping,
            });
            worker.onmessage = (event) => {
                if (event.data.id == workerTaskID) {
                    if (event.data.type === a958398b4ee45784f.pong) {
                        clearTimeout(timer);
                        resolve(true);
                    }
                }
            };
        });
        return Promise.resolve(result);
    }
    _connectionSettings = new a01d5a0be5bc5ddb1();
    get connectionSettings() {
        return this._connectionSettings.connectionSettings;
    }
    set connectionSettings(connectionSettings) {
        const connectionSettingsInternal = new a01d5a0be5bc5ddb1();
        connectionSettingsInternal.connectionSettings = connectionSettings;
        const workerTaskID = this.createWorkerTaskID();
        this.starPrinterWorker.postMessage({
            id: workerTaskID,
            type: a958398b4ee45784f.setConnectionSettings,
            connectionSettings: connectionSettingsInternal.serialize(),
        });
        this._connectionSettings = connectionSettingsInternal;
    }
    constructor(connectionSettings, commandParserWorker = null) {
        a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createInstanceCreatedString("StarPrinter"));
        try {
            if (!window.Worker) {
                const throwE = new StarIO10IllegalDeviceStateError(StarIO10ErrorMessage.WebWorkerUnavailable.message, StarIO10ErrorCode.WebWorkerUnavailable);
                a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
                throw throwE;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            let _ = this.starPrinterWorker; // starPrinterWorkerの初期化
            if (commandParserWorker) {
                this._starXpandCommandParserWorker = commandParserWorker;
                const workerTaskID = this.createWorkerTaskID();
                commandParserWorker.postMessage({
                    id: workerTaskID,
                    type: a958398b4ee45784f.incrementUserNumber,
                });
            }
            else {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                let __ = this.starXpandCommandParserWorker; // starXpandCommandParserWorkerの初期化
            }
            //各プロパティをaa8302368e5283575に渡す
            this.connectionSettings = connectionSettings;
            this.syncStarLogger();
        }
        catch {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            throw throwE;
        }
    }
    async open(options = new OpenOptions()) {
        const stopwatch = {
            start: Date.now(),
            elapsedTime: () => Date.now() - stopwatch.start,
        };
        if (options.timeout <= 0) {
            const throwE = new StarIO10ArgumentError(StarIO10ErrorMessage.InvalidTimeoutValue.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }
        const workerIsLiving = await this.checkStarPrinterWorker(options.timeout);
        if (!workerIsLiving) {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }
        /* eslint-disable @typescript-eslint/no-floating-promises */
        if (StarIO10Logger.isLogging) {
            this.startLogging();
        }
        else {
            this.stopLogging();
        }
        /* eslint-enable @typescript-eslint/no-floating-promises */
        const timer = setTimeout(() => {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }, options.timeout - stopwatch.elapsedTime() + 1000); // Worker内で発生するタイムアウトを優先するために、1秒延長する。
        const localOptions = new OpenOptions();
        localOptions.timeout = options.timeout - stopwatch.elapsedTime();
        const internalOptions = new a8fd55883fc29bb24(localOptions);
        const workerTaskID = this.createWorkerTaskID();
        this.starPrinterWorker.postMessage({
            id: workerTaskID,
            type: a958398b4ee45784f.open,
            options: internalOptions.serialize(),
        });
        return new Promise((resolve, reject) => {
            this.starPrinterWorker.onmessage = (event) => {
                if (event.data.id == workerTaskID) {
                    const { type, result, error } = event.data;
                    if (type === a958398b4ee45784f.openResponse) {
                        clearTimeout(timer);
                        if (result) {
                            resolve();
                        }
                        else {
                            if (error != null) {
                                const stario10Error = StarIO10ErrorFactory.degeneralize(error);
                                reject(stario10Error);
                            }
                            else {
                                const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
                                a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
                                return Promise.reject(throwE);
                            }
                        }
                    }
                }
            };
        });
    }
    async close() {
        const timeout = 5000;
        const stopwatch = {
            start: Date.now(),
            elapsedTime: () => Date.now() - stopwatch.start,
        };
        if (!(await this.checkStarPrinterWorker(timeout))) {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }
        const timer = setTimeout(() => {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }, timeout - stopwatch.elapsedTime() + 1000); // Worker内で発生するタイムアウトを優先するために、1秒延長する。
        const workerTaskID = this.createWorkerTaskID();
        this.starPrinterWorker.postMessage({
            id: workerTaskID,
            type: a958398b4ee45784f.close,
        });
        return new Promise((resolve, reject) => {
            this.starPrinterWorker.onmessage = (event) => {
                if (event.data.id == workerTaskID) {
                    const { type, result, error } = event.data;
                    if (type === a958398b4ee45784f.closeResponse) {
                        clearTimeout(timer);
                        if (result) {
                            resolve();
                        }
                        else {
                            if (error != null) {
                                const stario10Error = StarIO10ErrorFactory.degeneralize(error);
                                reject(stario10Error);
                            }
                            else {
                                const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
                                a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
                                return Promise.reject(throwE);
                            }
                        }
                    }
                }
            };
        });
    }
    async dispose() {
        try {
            await this.close();
        }
        catch {
            // 何もしない
        }
        this.starPrinterWorker.onmessage = null;
        this.starPrinterWorker.onerror = null;
        this.starPrinterWorker.terminate();
        this._starPrinterWorker = undefined;
        const workerTaskID = this.createWorkerTaskID();
        this.starXpandCommandParserWorker.postMessage({
            id: workerTaskID,
            type: a958398b4ee45784f.decrementUserNumber,
        });
        this.starXpandCommandParserWorker.onmessage = null;
        this.starXpandCommandParserWorker.onerror = null;
        this._starXpandCommandParserWorker = undefined;
    }
    async printRawData(data, options = new PrintOptions()) {
        const stopwatch = {
            start: Date.now(),
            elapsedTime: () => Date.now() - stopwatch.start,
        };
        if (options.timeout <= 0) {
            const throwE = new StarIO10ArgumentError(StarIO10ErrorMessage.InvalidTimeoutValue.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }
        if (!(await this.checkStarPrinterWorker(options.timeout))) {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }
        const timer = setTimeout(() => {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }, options.timeout - stopwatch.elapsedTime() + 1000); // Worker内で発生するタイムアウトを優先するために、1秒延長する。
        const localOptions = new PrintOptions();
        localOptions.timeout = options.timeout - stopwatch.elapsedTime();
        localOptions.enableCheckStatus = options.enableCheckStatus;
        // templateは、printRawDataでは使用しないため、コピーしない。
        const internalOptions = new a529e5d8b404994c7(localOptions);
        const workerTaskID = this.createWorkerTaskID();
        this.starPrinterWorker.postMessage({
            id: workerTaskID,
            type: a958398b4ee45784f.printRawData,
            data: data,
            options: internalOptions.serialize(),
        });
        return new Promise((resolve, reject) => {
            this.starPrinterWorker.onmessage = (event) => {
                if (event.data.id == workerTaskID) {
                    const { type, result, error } = event.data;
                    if (type === a958398b4ee45784f.printRawDataResponse) {
                        clearTimeout(timer);
                        if (result) {
                            resolve();
                        }
                        else {
                            if (error != null) {
                                const stario10Error = StarIO10ErrorFactory.degeneralize(error);
                                reject(stario10Error);
                            }
                            else {
                                const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
                                a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
                                return Promise.reject(throwE);
                            }
                        }
                    }
                }
            };
        });
    }
    async print(command, options = new PrintOptions()) {
        const stopwatch = {
            start: Date.now(),
            elapsedTime: () => Date.now() - stopwatch.start,
        };
        if (options.timeout <= 0) {
            const throwE = new StarIO10ArgumentError(StarIO10ErrorMessage.InvalidTimeoutValue.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }
        if (!(await this.checkStarXpandCommandParserWorker(options.timeout))) {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }
        const timer = setTimeout(() => {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }, options.timeout - stopwatch.elapsedTime() + 1000); // Worker内で発生するタイムアウトを優先するために、1秒延長する。
        const information = await this.getInformationInternal();
        const workerTaskID = this.createWorkerTaskID();
        // StarXpandCommandParserでコマンドをパースする
        this.starXpandCommandParserWorker.postMessage({
            id: workerTaskID,
            type: a958398b4ee45784f.parse,
            command: command,
            template: options.template,
            emulation: information.emulation,
            model: information.printerSpec.starXpandCommandParserModelName,
        });
        const parsedCommand = await new Promise((resolve, reject) => {
            this.starXpandCommandParserWorker.onmessage = (event) => {
                if (event.data.id == workerTaskID) {
                    clearTimeout(timer);
                    const { type, result, error } = event.data;
                    if (type === a958398b4ee45784f.parseResponse) {
                        if (result) {
                            resolve(result);
                        }
                        else {
                            if (error != null) {
                                const stario10Error = StarIO10ErrorFactory.degeneralize(error);
                                reject(stario10Error);
                            }
                            else {
                                const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
                                a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
                                return Promise.reject(throwE);
                            }
                        }
                    }
                }
            };
        });
        // 参照渡しを切るため、新しいPrintOptionsに値をコピーする。 templateは不要。
        const localOptions = new PrintOptions();
        localOptions.timeout = options.timeout - stopwatch.elapsedTime();
        localOptions.enableCheckStatus = options.enableCheckStatus;
        return this.printRawData(parsedCommand, localOptions);
    }
    async getStatus(options = new GetStatusOptions()) {
        const stopwatch = {
            start: Date.now(),
            elapsedTime: () => Date.now() - stopwatch.start,
        };
        if (options.timeout <= 0) {
            const throwE = new StarIO10ArgumentError(StarIO10ErrorMessage.InvalidTimeoutValue.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }
        if (!(await this.checkStarPrinterWorker(options.timeout))) {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }
        const timer = setTimeout(() => {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }, options.timeout - stopwatch.elapsedTime() + 1000); // Worker内で発生するタイムアウトを優先するために、1秒延長する。
        const localOptions = new GetStatusOptions();
        localOptions.timeout = options.timeout - stopwatch.elapsedTime();
        const internalOptions = new a65e77a918bb6bf2d(localOptions);
        const workerTaskID = this.createWorkerTaskID();
        this.starPrinterWorker.postMessage({
            id: workerTaskID,
            type: a958398b4ee45784f.getStatus,
            options: internalOptions.serialize(),
        });
        return new Promise((resolve, reject) => {
            this.starPrinterWorker.onmessage = (event) => {
                if (event.data.id == workerTaskID) {
                    const { type, result, status, error } = event.data;
                    if (type === a958398b4ee45784f.getStatusResponse) {
                        clearTimeout(timer);
                        if (result) {
                            if (status != null) {
                                const statusInternal = a341439e4e686906a.deserialize(status);
                                resolve(statusInternal.status);
                            }
                            else {
                                reject(new StarIO10CommunicationError(StarIO10ErrorMessage.ReadFailed.message));
                            }
                        }
                        else {
                            if (error != null) {
                                const stario10Error = StarIO10ErrorFactory.degeneralize(error);
                                reject(stario10Error);
                            }
                            else {
                                const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
                                a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
                                return Promise.reject(throwE);
                            }
                        }
                    }
                }
            };
        });
    }
    async setInformation(information) {
        const informationInternal = new aaca0adc50034daa9(information);
        const workerTaskID = this.createWorkerTaskID();
        this.starPrinterWorker.postMessage({
            id: workerTaskID,
            type: a958398b4ee45784f.setInformation,
            information: informationInternal.serialize(),
        });
    }
    async getInformation(options = new GetInformationOptions()) {
        const informationInternal = await this.getInformationInternal(options);
        return informationInternal.information;
    }
    async getInformationInternal(options = new GetInformationOptions()) {
        const stopwatch = {
            start: Date.now(),
            elapsedTime: () => Date.now() - stopwatch.start,
        };
        if (options.timeout <= 0) {
            const throwE = new StarIO10ArgumentError(StarIO10ErrorMessage.InvalidTimeoutValue.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }
        if (!(await this.checkStarPrinterWorker(options.timeout))) {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }
        const timer = setTimeout(() => {
            const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
            a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
            return Promise.reject(throwE);
        }, options.timeout - stopwatch.elapsedTime() + 1000); // Worker内で発生するタイムアウトを優先するために、1秒延長する。
        const localOptions = new GetInformationOptions();
        localOptions.timeout = options.timeout - stopwatch.elapsedTime();
        const internalOptions = new a21766f2e932e2b0f(localOptions);
        const workerTaskID = this.createWorkerTaskID();
        this.starPrinterWorker.postMessage({
            id: workerTaskID,
            type: a958398b4ee45784f.getInformation,
            options: internalOptions.serialize(),
        });
        return new Promise((resolve, reject) => {
            this.starPrinterWorker.onmessage = (event) => {
                if (event.data.id == workerTaskID) {
                    const { type, result, information, error } = event.data;
                    if (type === a958398b4ee45784f.getInformationResponse) {
                        clearTimeout(timer);
                        if (result) {
                            if (information != null) {
                                const starPrinterInformation = aaca0adc50034daa9.deserialize(information);
                                resolve(starPrinterInformation);
                            }
                            else {
                                const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
                                a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
                                return Promise.reject(throwE);
                            }
                        }
                        else {
                            if (error != null) {
                                const stario10Error = StarIO10ErrorFactory.degeneralize(error);
                                reject(stario10Error);
                            }
                            else {
                                const throwE = new StarIO10UnknownError(StarIO10ErrorMessage.UnknownError.message);
                                a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createErrorString(throwE));
                                return Promise.reject(throwE);
                            }
                        }
                    }
                }
            };
        });
    }
    createWorkerTaskID() {
        // WebWorkerのタスクを識別するための、一意なIDを生成
        return Math.floor(Math.random() * 10 ** 16);
    }
    async startLogging() {
        // WebWorkerを経由するとstaticな値も共有されないため、明示的に渡す。
        const workerTaskID = this.createWorkerTaskID(); // 一意なIDを生成
        this.starPrinterWorker.postMessage({
            id: workerTaskID,
            type: a958398b4ee45784f.startLogging,
        });
        this.starXpandCommandParserWorker.postMessage({
            id: workerTaskID,
            type: a958398b4ee45784f.startLogging,
        });
    }
    async stopLogging() {
        // WebWorkerを経由するとstaticな値も共有されないため、明示的に渡す。
        const workerTaskID = this.createWorkerTaskID();
        this.starPrinterWorker.postMessage({
            id: workerTaskID,
            type: a958398b4ee45784f.stopLogging,
        });
        this.starXpandCommandParserWorker.postMessage({
            id: workerTaskID,
            type: a958398b4ee45784f.stopLogging,
        });
    }
    /* eslint-disable @typescript-eslint/no-floating-promises */
    syncStarLogger() {
        if (StarIO10Logger.isLogging) {
            this.startLogging();
        }
        else {
            this.stopLogging();
        }
    }
}
